#include "CGen2PassDialog.h"

#include <QMessageBox>

#include <QrfeReaderInterface>


CGen2PassDialog::CGen2PassDialog(QWidget *parent)
    : QDialog(parent)
{
	ui.setupUi(this);
	connect(ui.okButton, 			SIGNAL(clicked()), 					this, SLOT(tryAccept()));
	connect(ui.cancelButton, 		SIGNAL(clicked()), 					this, SLOT(reject()));

}

CGen2PassDialog::~CGen2PassDialog()
{

}


int CGen2PassDialog::exec(QString text, QByteArray &passw)
{
	ui.textLabel->setText(text);
	ui.passwordLineEdit->setText("00-00-00-00");
	ui.passwordLineEdit->setCursorPosition(0);

	int ret = QDialog::exec();

	passw = m_passw;

	return ret;
}


void CGen2PassDialog::tryAccept()
{
	if(!ui.passwordLineEdit->hasAcceptableInput())
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	bool ok = false;
	m_passw = QrfeGlobal::stringToBytes(ui.passwordLineEdit->text(), &ok);
	if(!ok)
	{
		QMessageBox::critical(this, "Error", "The password is not a valid!");
		return;
	}

	QDialog::accept();
}
